﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Linq;
using System.Text;
using System.Windows.Forms;
using CashierCrisis.Behaviors;


namespace BehaviorTreeEditor
{
    public partial class Form1 : Form
    {
        BehaviorFactory factory = new BehaviorFactory();
        List<Type> actions = new List<Type>();
        List<Type> composites = new List<Type>();
        List<Type> decorators = new List<Type>();

        public Form1()
        {
            InitializeComponent();
            actions.Add(typeof(Wait));
            composites.Add(typeof(Selector));
            composites.Add(typeof(Sequence));
            composites.Add(typeof(Parallel));
            decorators.Add(typeof(Repeat));
            decorators.Add(typeof(CashierCrisis.Behaviors.Timer));


        }

        private void addBehaviorButton_Click(object sender, EventArgs e)
        {
            Behavior behavior = factory.Create(behaviorPalette.SelectedItem.ToString());

            if (behaviorTreeView.SelectedNode == null)
            {
                behaviorTreeView.Nodes.Add(new BehaviorTreeNode(behavior));
            }

            if (behaviorTreeView.SelectedNode != null)
            {
                BehaviorTreeNode node = behaviorTreeView.SelectedNode as BehaviorTreeNode;
                Type nodeType = node.Behavior.GetType();
                
                foreach(Type t in actions)
                {
                    if (t == nodeType)
                        return;
                }

                foreach (Type t in decorators)
                {
                    if (t == nodeType)
                    {
                        node.Nodes.Clear();
                    }
                }

                node.Behavior.Add(behavior);
                behaviorTreeView.SelectedNode = node;
                behaviorTreeView.SelectedNode.Nodes.Add(new BehaviorTreeNode(behavior));
            }
        }

        private void behaviorTreeView_NodeMouseClick(object sender, TreeNodeMouseClickEventArgs e)
        {
            BehaviorTreeNode node = behaviorTreeView.SelectedNode as BehaviorTreeNode;
            if(node !=null)
                behaviorPropertyGrid.SelectedObject = node.Behavior;
        }
    }
}
